{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 09/10/99
 * Ultim dia:  10/10/99
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitCalculFFT;

{************************************************}
INTERFACE
{************************************************}

Uses UnitDadesGlobus2;

function CalculFft(GrandariaBufferFFT:LongInt):integer;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitMatematiques, UnitEspectroscopi;

function CalculFft(GrandariaBufferFFT:LongInt):integer;
var
  m,irem,l,le,le1,i,j,k,ip:integer;
  ur,ui,wr,wi,tr,ti,temp:single;
  comodi,comodi2:single;
  //DR,DI: array[1..BytesBufferMaxim] of single;
  DR,DI: SoReal;

begin
  CalculFft:=0;
  for i:=1 to GrandariaBufferFFT do begin
    DR[i]:= CoeficientsDenFourier[2,i];
    DI[i]:= 0.;
    CoeficientsDenFourier[2,i]:=0;
  end;
//Adaptada a l'oida
  if FormEspectroscopi.CheckBoxMagic.Checked then begin
    CalculPreemfasis(DR,GrandariaBufferFFT);
    CalculFinestradeHamming(DR,GrandariaBufferFFT);
    for i:=1 to GrandariaBufferFFT do DR[i]:=2*DR[i];
  end;
//Clcul FFT
  j:=1;
  comodi:=0.5;
  for i:=1 to GrandariaBufferFFT-1 do begin
    if i<j then begin
      tr:=DR[j];
      ti:=DI[j];
      DR[j]:=DR[i];
      DI[j]:=DI[i];
      DR[i]:=tr;
      DI[i]:=ti;
      k:=round(GrandariaBufferFFT*comodi);
      while k<j do begin
        j:=j-k;
        k:=round(k*comodi);
      end;
    end else begin
      k:=round(GrandariaBufferFFT*comodi);
      while k<j do begin
        j:=j-k;
        k:=round(k*comodi);
      end;
    end;
    j:=j+k;
  end;
  m:=0;
  irem:=GrandariaBufferFFT;
  while irem>1 do begin
    irem:=round(irem*comodi);
    m:=m+1;
  end;
  for l:=1 to m do begin
    le:=round(exp(l*ln(2)));
    le1:=round(le*comodi);
    ur:=1.0;
    ui:=0;
    wr:=cos(pi/le1);
    wi:=-sin(pi/le1);
    for j:=1 to le1 do begin
      i:=j;
      while i<=GrandariaBufferFFT do begin
        ip:=i+le1;
        tr:=DR[ip]*ur-DI[ip]*ui;
        ti:=DI[ip]*ur+DR[ip]*ui;
        DR[ip]:=DR[i]-tr;
        DI[ip]:=DI[i]-ti;
        DR[i]:=DR[i]+tr;
        DI[i]:=DI[i]+ti;
        i:=i+le;
      end;
      temp:=ur*wr-ui*wi;
      ui:=ui*wr+ur*wi;
      ur:=temp;
    end;
  end;
  for i:=1 to GrandariaBufferFFT do begin
    DR[i]:=DR[i]/GrandariaBufferFFT;
    DI[i]:=DI[i]/GrandariaBufferFFT;
  end;
  for i:=((GrandariaBufferFFT div 2)+1) to GrandariaBufferFFT do begin
    DR[i]:=0;
    DI[i]:=0;
  end;
  Comodi2:=Muestras/GrandariaBufferFFT;
  For i:=1 to (GrandariaBufferFFT div 2) do begin
    //CoeficientsDenFourier[1,i]:=(i)*Comodi2;
    CoeficientsDenFourier[1,i]:=(i-1)*Comodi2;
    CoeficientsDenFourier[2,i]:=SQRT(DR[i]*DR[i]+DI[i]*DI[i]);
  end;
end;

{*******************************************************}
var
  i:integer;
begin
  for i:=1 to BytesBufferMaxim do
    CoeficientsDenFourier[1,i]:=0;
end.
{*******************************************************}


